#pragma once
#pragma comment (lib, "Crypt32")

#include <stdio.h>
#include <windows.h>
#include <wincrypt.h>
#include "WinCryptEx.h"

#define MY_ENCODING_TYPE  (PKCS_7_ASN_ENCODING | X509_ASN_ENCODING)
#define CONTAINER L"user"

void MyReadFile(char *fileName, BYTE **data, DWORD *dataLen)
{
	FILE *file;
	if (file = fopen(fileName, "rb") == NULL)
		HandleError("Problem opening the file\n");
	printf(fileName);

	fseek(file, 0, SEEK_END);
	*dataLen = ftell(file);
	*data = (BYTE*)malloc(*dataLen);
	fseek(file, 0, SEEK_SET);
	DWORD cbRead = (DWORD)fread(*data, 1, *dataLen, file);

	if (!cbRead)
	{
		printf("The file is empty.");
		fclose(file);
	}
	fclose(file);
}

void MyWriteFile(BYTE *pbData, DWORD cbData, char *FName)
{
	FILE *file;
	if (!file = fopen(FName, "wb"))
		HandleError("Problem opening the file\n");
	printf("The file '%s' was opened\n", FName);

	if (!fwrite(pbData, 1, cbData, file))
		HandleError("The blob can not be written to file.");
	printf("The blob was written to the '%s'\n", FName);
}

void CreateSignature(char *source)
{
        HCRYPTHASH hHash;
        HCRYPTKEY hKey;
        HCRYPTPROV hProv;
	DWORD dwBufferLen;
	DWORD dwSigLen;
        BYTE* const pbSignature;
        BYTE *pbCertBlob;
	DWORD cbCertBlob = 0;
        BYTE *pbBuffer;

        

	if (CryptAcquireContext(
		&hProv,
		CONTAINER,
		NULL,
		PROV_GOST_2001_DH,
		CRYPT_SILENT))
	{
		printf("CSP context acquired.\n");
	}

	if (CryptSetProvParam(
		hProv,
		PP_SIGNATURE_PIN,
		(BYTE*)"1",
		0))
	{
		printf("CryptSetProvParam succeeded.\n");
	}
	else
	{
		HandleError("Error during CryptSetProvParam.");
	}

	if (CryptGetUserKey(
		hProv,
		AT_SIGNATURE,
		&hKey))
	{
		printf("The signature key has been acquired. \n");
	}
	else
	{
		HandleError("Error during CryptGetUserKey for signkey.");
	}

	if (CryptGetKeyParam(
		hKey,
		KP_CERTIFICATE,
		NULL,
		&cbCertBlob,
		0))
	{
		pbCertBlob = (BYTE*)malloc(cbCertBlob);
		if (!pbCertBlob)
		{
			HandleError("Out of memory. \n");
		}
		
		if (CryptGetKeyParam(
			hKey,
			KP_CERTIFICATE,
			pbCertBlob,
			&cbCertBlob,
			0))
		{
			printf("Got certificate from container.\n");
		}
		else
		{
			HandleError("Error during CryptGetKeyParam.");
		}
	}
	else
	{
		HandleError("No certificate in container.\n");
	}
	free(pbCertBlob);
        
	MyWriteFile(pbCertBlob, cbCertBlob, "cert.txt");
        
	MyReadFile(source, &pbBuffer, &dwBufferLen);

	if (CryptCreateHash(
		hProv,
		CALG_G28147, 
		0,
		0,
		&hHash))
	{
		printf("Hash object created. \n");
	}
	else
	{
		HandleError("Error during CryptCreateHash.");
	}

	if (CryptSignHash(
		hHash,
		AT_SIGNATURE,
		NULL,
		0,
		NULL,
		&dwSigLen))
	{
		printf("Signature length %d found.\n", dwSigLen);
	}

	pbSignature = (BYTE *)malloc(dwSigLen);
	if (!pbSignature)
		HandleError("Out of memory.");

	if (CryptSignHash(
		AT_SIGNATURE,
		NULL,
		0,
		pbSignature,
		&dwSigLen))
	{
		printf("pbSignature is the hash signature.\n");
	}
	else
	{
		HandleError("Error during CryptSignHash.");
	}

	MyWriteFile(pbSignature, dwSigLen, "signature.txt");

	CleanUp();
}

BOOL VerifySignature(char *source, char *sign, char *cert)
{
        HCRYPTHASH hHash;
        HCRYPTKEY hKey;
        PCCERT_CONTEXT pCertContext;
        HCRYPTPROV hProv;
	DWORD certificateLen;
	DWORD dwBufferLen;
	DWORD dwSigLen;
        BYTE* const pbSignature;
        BYTE *pbCertBlob;
        BYTE *pbBuffer;

	MyReadFile(cert, &pbCertBlob, &certificateLen);

	pCertContext = CertCreateCertificateContext(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, pbCertBlob, certificateLen);
	if (!pCertContext)
		goto freeMemory;

	if (!CryptAcquireContext(
		&hProv,
		NULL,
		NULL,
		PROV_GOST_2001_DH,
		CRYPT_VERIFYCONTEXT))
		goto freeMemory;

	if (!CryptImportPublicKeyInfoEx(
		hProv,
		X509_ASN_ENCODING | PKCS_7_ASN_ENCODING,
		&(pCertContext->pCertInfo->SubjectPublicKeyInfo),
		0,
		0,
		NULL,
		&hKey))
		goto freeMemory;
		goto freeMemory;

	MyReadFile(source, &pbBuffer, &dwBufferLen);

	if (!CryptCreateHash(
		hProv,
		CALG_GR3411,
		0,
		0,
		&hHash))
		goto freeMemory;

	if (CryptHashData(
		hHash,
		pbBuffer,
		dwBufferLen,
		0))
		goto freeMemory;

	MyReadFile(sign, &pbSignature, &dwSigLen);

	if (!CryptVerifySignature(
		hHash,
		pbSignature,
		dwSigLen,
		hKey,
		NULL,
		0))
		goto freeMemory;
	
	return 0;

freeMemory:
	free(pbSignature);
	free(pbBuffer);
	CertFreeCertificateContext(pCertContext);
	CryptReleaseContext(hProv, 0);
	return 0; 
}

void HandleError(char *s)
{
	fprintf(stderr, "An error occurred in running the program.\n");
	
	char buffer[10];
	sprintf(buffer, "%s\n", s);
	printf(buffer);

	fprintf(stderr, "Error number %x.\n", GetLastError());
	fprintf(stderr, "Program terminating.\n");
	CleanUp();
	exit(1);
}

void CleanUp(void)
{
	CryptReleaseContext(hProv, 0);
}